import {
    system,
    world,
    ItemStack,
    EquipmentSlot,
    GameMode,
} from "@minecraft/server"
import { Adult, Baby, Item, SpawnEgg } from '../item/Hamster'
const hamsterColors = [
    "black",
    "blackwhite",
    "brown",
    "grey",
    "orange",
    "peach",
    "white"
]
const hamsterPatterns = [
    ""
]
const interactSeeds = [
    "minecraft:wheat_seeds",
    "minecraft:beetroot_seeds",
    "minecraft:melon_seeds",
    "minecraft:pumpkin_seeds",
    "minecraft:pitcher_pod",
    "minecraft:torchflower_seeds"
]
export function getColor(item) {
    for (const spawner of [Adult, Baby, Item, SpawnEgg]) {
        if (!spawner.includes(item)) continue
        for (let i = 0; i < hamsterColors.length; i++) {
            if (spawner[i] == item) {
                return hamsterColors[i]
            }
        }
    }
}
export function getPattern(item) {
    return 'blank'
}
export function getHamsterItemData(stack) {
    if (!stack) return undefined;
    return {
        name: stack.getDynamicProperty("sf_nba:name_tag") ?? undefined,
        skin: hamsterColors.indexOf(getColor(stack.typeId)) ?? 0,
        overlay: hamsterPatterns.indexOf(getPattern(stack.typeId)) ?? 0,
        isBaby: stack.getDynamicProperty("sf_nba:is_baby") ?? false,
        isFollowingOwner: stack.getDynamicProperty("sf_nba:is_following_owner") ?? true,
        accessory: stack.getDynamicProperty("sf_nba:equipped_accessory") ?? -1,
        overfeedLevel: stack.getDynamicProperty("sf_nba:overfeed_level") ?? 0,
        color: stack.getDynamicProperty("sf_nba:color") ?? 15,
        seedsStorage: [
            stack.getDynamicProperty("sf_nba:overfeed_item_1"),
            stack.getDynamicProperty("sf_nba:overfeed_item_2"),
            stack.getDynamicProperty("sf_nba:overfeed_item_3"),
            stack.getDynamicProperty("sf_nba:overfeed_item_4")
        ]
    }
}
function getEquipment(entity, slot) {
    const equip = entity.getComponent("equippable")
    const item = equip?.getEquipment(slot)
    return item
}
function getSpawnLocation(clickedFace, clickedBlock) {
    if (clickedFace == "North") return { x: clickedBlock.x + 0.5, y: clickedBlock.y + 0.5, z: clickedBlock.z - 0.5 }
    if (clickedFace == "South") return { x: clickedBlock.x + 0.5, y: clickedBlock.y + 0.5, z: clickedBlock.z + 1.5 }
    if (clickedFace == "East") return { x: clickedBlock.x + 1.5, y: clickedBlock.y + 0.5, z: clickedBlock.z + 0.5 }
    if (clickedFace == "West") return { x: clickedBlock.x - 0.5, y: clickedBlock.y + 0.5, z: clickedBlock.z + 0.5 }
    if (clickedFace == "Up") return { x: clickedBlock.x + 0.5, y: clickedBlock.y + 1.0, z: clickedBlock.z + 0.5 }
    if (clickedFace == "Down") return { x: clickedBlock.x + 0.5, y: clickedBlock.y, z: clickedBlock.z + 0.5 }
}
function generateItem(hamster) {
    const hasName = hamster.nameTag.length > 0
    const variantComponent = hamster.getComponent("variant")
    const markVariantComponent = hamster.getComponent("mark_variant")
    const isBabyComponent = hamster.getComponent("is_baby")
    const equippedAccessory = hamster.getProperty("sf_nba:equipped_accessory")
    const variant = variantComponent?.value ?? 0
    const markVariant = markVariantComponent?.value ?? 0
    const color = hamster.getProperty("sf_nba:dye")
    const overfeedLevel = hamster.getProperty("sf_nba:overfeed_level")
    const calories = hamster.getDynamicProperty("sf_nba:calories") ?? 0
    const isFollowingOwner = hamster.getProperty("sf_nba:is_following_owner")
    const item = new ItemStack(Item[variant])
    if (hasName) {
        const name = hamster.nameTag
        item.setDynamicProperty("sf_nba:name_tag", name)
        item.nameTag = name
    }
    item.setDynamicProperty("sf_nba:variant", variant)
    item.setDynamicProperty("sf_nba:mark_variant", markVariant)
    item.setDynamicProperty("sf_nba:color", color)
    item.setDynamicProperty("sf_nba:is_baby", isBabyComponent != null)
    item.setDynamicProperty("sf_nba:equipped_accessory", equippedAccessory)
    item.setDynamicProperty("sf_nba:overfeed_level", overfeedLevel)
    item.setDynamicProperty("sf_nba:calories", calories)
    item.setDynamicProperty("sf_nba:is_following_owner", isFollowingOwner)
    if (overfeedLevel > 0) {
        for (let i = 0; i < overfeedLevel; i += 1) {
            item.setDynamicProperty(`sf_nba:overfeed_item_${i + 1}`, hamster.getDynamicProperty(`sf_nba:overfeed_item_${i + 1}`))
        }
    }
    return item
}
export function place_hamster(e) {
    if (SpawnEgg.includes(e.itemStack)) return
    const { block, blockFace, source, itemStack } = e
    const data = getHamsterItemData(itemStack)
    const hamster = block.dimension.spawnEntity("sf_nba:hamster<sf_nba:placed>", getSpawnLocation(blockFace, block))
    hamster.triggerEvent(`sf_nba:set_variant_${getColor(itemStack.typeId)}`)
    hamster.triggerEvent(`sf_nba:set_pattern_blank`)
    if (data.name) {
        hamster.nameTag = data.name
    }
    if (data.isBaby) {
        hamster.triggerEvent("sf_nba:set_baby")
    } else {
        hamster.triggerEvent("sf_nba:set_adult")
    }
    hamster.setProperty(`sf_nba:overfeed_level`, data.overfeedLevel)
    if (data.overfeedLevel > 0) {
        for (let i = 0; i < data.overfeedLevel; i += 1) {
            hamster.setDynamicProperty(`sf_nba:overfeed_item_${i + 1}`, itemStack.getDynamicProperty(`sf_nba:overfeed_item_${i + 1}`))
        }
    }
    hamster.setDynamicProperty(`sf_nba:calories`, data.calories)
    const tameComponent = hamster.getComponent("tameable")
    tameComponent.tame(source)
    hamster.setDynamicProperty("sf_nba:owner_id", source.id)
    hamster.triggerEvent("sf_nba:on_tame")
    hamster.setProperty(`sf_nba:dye`, data.color)
    if (data.accessory != null) hamster.setProperty("sf_nba:equipped_accessory", data.accessory)
    const gameMode = (source).getGameMode()
    if (gameMode != GameMode.creative) {
        const equipment = source.getComponent("equippable")
        if (equipment != null) {
            equipment.setEquipment(EquipmentSlot.Mainhand)
        }
    }
}
world.afterEvents.itemUseOn.subscribe(e => {
    const { block, blockFace, itemStack, source } = e
    const id = itemStack.typeId
    if (!itemStack) return
    if (block.hasTag('sf_hba:hamster_bed')) return
    if (block.hasTag('sf_hba:hamster_hut')) return
    if (block.typeId == 'sf_hba:hamster_cannon') return
    if (block.permutation.matches('minecraft:frame') || block.permutation.matches('minecraft:glow_frame')) return;
    if (!SpawnEgg.includes(id)) return
    const color = getColor(id)
    const pattern = getPattern(id)
    const location = getSpawnLocation(blockFace, block)
    const hamster = source.dimension.spawnEntity('sf_nba:hamster', location)
    hamster.triggerEvent(`sf_nba:set_variant_${color}`)
    hamster.triggerEvent(`sf_nba:set_pattern_${pattern}`)
    hamster.teleport(location, { keepVelocity: false, facingLocation: source.location })
})
world.beforeEvents.itemUseOn.subscribe(e => {
    if (!e.isFirstEvent) return
    if (!e.itemStack) return
    if (![...Adult, ...Baby, ...Item].includes(e.itemStack.typeId)) return
    if (e.block.hasTag('sf_hba:hamster_bed')) return
    if (e.block.hasTag('sf_hba:hamster_hut')) return
    if (e.block.typeId == 'sf_hba:hamster_cannon') return
    system.run(() => place_hamster(e))
})
system.afterEvents.scriptEventReceive.subscribe(e => {
    const entity = e.sourceEntity
    if (e.id == "sf_nba:hamster_squish_test") {
        try {
            if ((entity?.typeId == "sf_nba:hamster")) {
                entity.addTag("squish_test")
                const player = entity.dimension.getEntities({ type: "minecraft:player", location: entity.location, closest: 1 })[0]
                if (player != null) {
                    if (player.getVelocity().y < 0) {
                        try {
                            player?.runCommand("event entity @e[tag=squish_test,c=1] sf_nba:squish")
                        } catch (e) { }
                    }
                }
                system.runTimeout(() => { entity.removeTag("squish_test") }, 3)
            }
        }
        catch (err) { }
    }
    else if (e.id == "sf_nba:hamster_drop_item") {
        try {
            if ((entity?.typeId == "sf_nba:hamster")) {
                entity.dimension.spawnItem(new ItemStack(e.message), entity.location)
            }
        }
        catch (err) {
        }
    }
    else if (e.id == "sf_nba:hamster_consume_overfeed_item") {
        try {
            if ((entity?.typeId == "sf_nba:hamster")) {
                const overfeedLevel = entity.getProperty("sf_nba:overfeed_level")
                if (overfeedLevel > 0) {
                    const overfeedLevel = entity.getProperty("sf_nba:overfeed_level")
                    entity.setDynamicProperty(`sf_nba:overfeed_item_${overfeedLevel}`)
                    entity.setProperty("sf_nba:overfeed_level", Math.max(0, overfeedLevel - 1))
                }
            }
        }
        catch (err) {
        }
    }
    else if (e.id == "sf_nba:hamster_drop_overfeed_item") {
        try {
            if ((entity?.typeId == "sf_nba:hamster")) {
                const overfeedLevel = entity.getProperty("sf_nba:overfeed_level")
                if (overfeedLevel > 0) {
                    entity.dimension.spawnItem(new ItemStack(entity.getDynamicProperty(`sf_nba:overfeed_item_${overfeedLevel}`)), entity.location)
                    entity.setDynamicProperty(`sf_nba:overfeed_item_${overfeedLevel}`)
                    entity.setProperty("sf_nba:overfeed_level", Math.max(0, overfeedLevel - 1))
                }
            }
        }
        catch (err) {
        }
    }
    else if (e.id == "sf_nba:hamster_holding_item") {
        try {
            if ((entity?.typeId == "sf_nba:hamster")) {
                try {
                    const newOverfeedLevel = Math.min(4, ((entity.getProperty("sf_nba:overfeed_level")) ?? 0) + 1)
                    entity.setProperty("sf_nba:overfeed_level", newOverfeedLevel)
                    entity.setDynamicProperty(`sf_nba:overfeed_item_${newOverfeedLevel}`, e.message)
                }
                catch (err) { }
            }
        }
        catch (err) {
        }
    }
    else if (e.id == "sf_nba:burn_calories") {
        const calories = entity?.getDynamicProperty('sf_nba:calories')
        const overfeedLevel = entity?.getProperty('sf_nba:overfeed_level')
        if (calories == undefined) {
            entity?.setDynamicProperty('sf_nba:calories', overfeedLevel * 1500)
            return
        }
        if (calories == 0) return entity?.setProperty('sf_nba:overfeed_level', 0)
        if (!overfeedLevel) return
        entity?.setProperty('sf_nba:overfeed_level', Math.ceil(calories / 1500))
        entity?.setDynamicProperty('sf_nba:calories', calories - 1)
    }
    else if (e.id == 'sf_nba:place_hamster') {
        const player = world.getPlayers().filter(p => p.id == Number(e.message))[0]
        const item = getEquipment(player, "Mainhand")
        const data = getHamsterItemData(item)
        e.sourceEntity.runCommand(`scriptevent sf_hba:send_data_to_hamster_plus ${JSON.stringify(data)}`)
    } else if (e.id == "sf_nba:set_owner_id") {
        entity.setDynamicProperty('sf_nba:owner_id', e.message)
    }
})
world.afterEvents.entityLoad.subscribe(e => {
    const entity = e.entity
    if ((entity.typeId == "sf_nba:hamster") && entity.hasTag("squish_test")) {
        try {
            entity.removeTag("squish_test")
        }
        catch (err) { }
    }
})
world.beforeEvents.playerInteractWithEntity.subscribe(e => {
    const { itemStack, player, target } = e
    if (target.typeId != 'sf_nba:hamster') return
    if (itemStack?.typeId != 'sf_nba:capture_net') {
        if ((itemStack != null) && (target.typeId == 'sf_nba:hamster') && (interactSeeds.indexOf(itemStack.typeId) > -1)) {
            const tameComponent = target.getComponent('is_tamed')
            system.run(() => {
                target.setDynamicProperty('sf_nba:tamed', tameComponent != null)
            })
        }
    } else {
        const ownerId = target.getDynamicProperty('sf_nba:owner_id')
        const container = player.getComponent('inventory').container
        if (ownerId) {
            if (player.id !== ownerId) return e.cancel = true
        } else {
            if (target.getComponent('tameable')?.ownerId != player.id) return e.cancel = true
        }
        system.run(() => {
            if (container.emptySlotsCount == 0) {
                target.dimension.spawnItem(generateItem(target), target.location);
            } else {
                container.addItem(generateItem(target))
            }
            target.remove()
        })
    }
})
world.afterEvents.playerInteractWithEntity.subscribe(e => {
    const entity = e.target
    const player = e.player
    const itemStack = e.beforeItemStack
    if ((itemStack != null) && (entity.typeId == "sf_nba:hamster") && (interactSeeds.indexOf(itemStack.typeId) > -1)) {
        try {
            if (!(entity.getDynamicProperty("sf_nba:tamed"))) {
                const tameComponent = e.target.getComponent('minecraft:tameable')
                try {
                    if (!tameComponent) return
                    if (!tameComponent.tamedToPlayer) return
                    if (!tameComponent?.isTamed || e.itemStack.typeId === 'sf_nba:capture_net') return
                    e.target.setDynamicProperty('sf_nba:owner_id', tameComponent.tamedToPlayerId)
                } catch (e) { }
                return
            }
            if (entity.getDynamicProperty("sf_nba:full_hp") == null) {
                const healthComponent = entity.getComponent("health")
                entity.setDynamicProperty("sf_nba:full_hp", (healthComponent != null) && (healthComponent.currentValue == healthComponent.effectiveMax))
            }
            if (!(entity.getDynamicProperty("sf_nba:full_hp")))
                return
            const overfeedLevel = (entity.getProperty("sf_nba:overfeed_level")) ?? 0
            if (overfeedLevel == 4)
                return
            const newOverfeedLevel = Math.min(4, overfeedLevel + 1)
            entity.setProperty("sf_nba:overfeed_level", newOverfeedLevel)
            entity.setDynamicProperty('sf_nba:calories', newOverfeedLevel * 1500)
            entity.setDynamicProperty(`sf_nba:overfeed_item_${newOverfeedLevel}`, itemStack.typeId)
            entity.dimension.playSound("sf_nba.hamster.overfed", entity.location)
        }
        catch (err) { }
    }
})
world.afterEvents.entityHealthChanged.subscribe(e => {
    const entity = e.entity
    const newValue = e.newValue
    if (entity.typeId == "sf_nba:hamster") {
        try {
            const healthComponent = entity.getComponent("health")
            system.runTimeout(() => { entity.setDynamicProperty("sf_nba:full_hp", (healthComponent != null) && (Math.min(newValue, healthComponent.effectiveMax) == healthComponent.effectiveMax)) }, 2)
        }
        catch (err) {
        }
    }
})